/*
 * Decompiled with CFR 0.152.
 */
package dendro_command_line;

import dendro_command_line.BesanconValuesReader;
import dendro_command_line.Columns;
import dendro_command_line.Measurement;
import dendro_command_line.Menu;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class BesanconReader {
    int lines = 0;
    int sets;
    ArrayList<Measurement> measurementsList = new ArrayList();

    public void ReadBesanconFile(String path) {
        File file = new File(path);
        Measurement actualMeasurement = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
            String line = br.readLine();
            Menu.clearScreen();
            System.out.print("Reading file... ");
            while (line != null) {
                ++this.lines;
                String[] columns = line.trim().split("\\s+");
                if (columns[0].startsWith(".")) {
                    actualMeasurement = new Measurement(columns[1]);
                    ++this.sets;
                } else if (columns[0].equals("longueur:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setLongueur(Integer.parseInt(columns[1]));
                    }
                } else if (columns[0].equals("position:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setPosition(Integer.parseInt(columns[1]));
                    }
                } else if (columns[0].equals("fin:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setFin(Integer.parseInt(columns[1]));
                    }
                } else if (columns[0].equals("origine:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setOrigine(Integer.parseInt(columns[1]));
                    }
                } else if (columns[0].equals("terme:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setTerme(Integer.parseInt(columns[1]));
                    }
                } else if (columns[0].equals("minimum:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setMinimum(Float.parseFloat(columns[1]));
                    }
                } else if (columns[0].equals("maximum:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setMaximum(Float.parseFloat(columns[1]));
                    }
                } else if (columns[0].equals("total:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setTotal(Float.parseFloat(columns[1]));
                    }
                } else if (columns[0].equals("moyenne:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setMoyenne(Float.parseFloat(columns[1]));
                    }
                } else if (columns[0].equals("\u00e9c.abs:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setEc_abs(Float.parseFloat(columns[1]));
                    }
                } else if (columns[0].equals("\u00e9cart-type:")) {
                    if (actualMeasurement != null) {
                        actualMeasurement.setEcart_type(Float.parseFloat(columns[1]));
                    }
                } else if (line.startsWith("VAL  EBES:") | line.startsWith("VAL  POL1:")) {
                    if (actualMeasurement != null) {
                        BesanconValuesReader valuesReader = new BesanconValuesReader(this.lines, file, actualMeasurement);
                        actualMeasurement.setValues(valuesReader.ReadSeries());
                    }
                } else if (line.endsWith(";") && actualMeasurement != null) {
                    this.measurementsList.add(actualMeasurement);
                }
                line = br.readLine();
            }
            br.close();
            System.out.print("Done.");
            System.out.println("");
            System.out.println("Read " + this.lines + " lines of file");
            System.out.println("Read " + this.measurementsList.size() + " curves in file");
            Float lowestValue = Float.valueOf(this.FindLowestValue(this.measurementsList));
            System.out.print("Min. value of all the series/curves " + lowestValue);
            ArrayList<Measurement> measurementsWithThisValue = this.FindMeaurementWithThisValue(this.measurementsList, lowestValue);
            System.out.print(", found in ");
            for (int i = 0; i < measurementsWithThisValue.size(); ++i) {
                System.out.print(measurementsWithThisValue.get(i).getId() + " ");
            }
            Float greaterValue = Float.valueOf(this.FindGreaterValue(this.measurementsList));
            System.out.println("");
            System.out.print("Max. value of all the series/curves " + greaterValue);
            measurementsWithThisValue = this.FindMeaurementWithThisValue(this.measurementsList, greaterValue);
            System.out.print(", found in ");
            for (int i = 0; i < measurementsWithThisValue.size(); ++i) {
                System.out.print(measurementsWithThisValue.get(i).getId() + " ");
            }
            Menu menu = new Menu();
            menu.setScreenHasToBeCleaned(false);
            menu.ShiftValues(this.measurementsList);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("file not found");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public float FindLowestValue(ArrayList<Measurement> measurementsList) {
        ArrayList<Float> allValues = new ArrayList<Float>();
        for (int i = 0; i < measurementsList.size(); ++i) {
            for (int y = 0; y < measurementsList.get(i).getValues().size(); ++y) {
                allValues.add(measurementsList.get(i).getValues().get(y));
            }
        }
        float minIndex = ((Float)Collections.min(allValues)).floatValue();
        return minIndex;
    }

    public float FindGreaterValue(ArrayList<Measurement> measurementsList) {
        ArrayList<Float> allValues = new ArrayList<Float>();
        for (int i = 0; i < measurementsList.size(); ++i) {
            for (int y = 0; y < measurementsList.get(i).getValues().size(); ++y) {
                allValues.add(measurementsList.get(i).getValues().get(y));
            }
        }
        float minIndex = ((Float)Collections.max(allValues)).floatValue();
        return minIndex;
    }

    public ArrayList<Measurement> FindMeaurementWithThisValue(ArrayList<Measurement> measurementsList, Float value) {
        ArrayList<Measurement> measurementsWithThisValue = new ArrayList<Measurement>();
        for (int i = 0; i < measurementsList.size(); ++i) {
            for (int y = 0; y < measurementsList.get(i).getValues().size(); ++y) {
                if (!(Math.abs(measurementsList.get(i).getValues().get(y).floatValue() - value.floatValue()) < 1.0f)) continue;
                measurementsWithThisValue.add(measurementsList.get(i));
            }
        }
        return measurementsWithThisValue;
    }

    public float FindLowestValueOfSingleSeries(Measurement measurement) {
        ArrayList<Float> allValues = new ArrayList<Float>();
        for (int i = 0; i < measurement.getValues().size(); ++i) {
            if ((double)measurement.getValues().get(i).floatValue() == 0.0) continue;
            allValues.add(measurement.getValues().get(i));
        }
        float minIndex = ((Float)Collections.min(allValues)).floatValue();
        return minIndex;
    }

    public float FindGreaterValueOfSingleSeries(Measurement measurement) {
        ArrayList<Float> allValues = new ArrayList<Float>();
        for (int i = 0; i < measurement.getValues().size(); ++i) {
            allValues.add(measurement.getValues().get(i));
        }
        float maxIndex = ((Float)Collections.max(allValues)).floatValue();
        return maxIndex;
    }

    public void ShiftValues(float minValue, ArrayList<Measurement> measurementsList) {
        for (int i = 0; i < measurementsList.size(); ++i) {
            ArrayList<Float> shiftedValues = new ArrayList<Float>();
            for (int y = 0; y < measurementsList.get(i).getValues().size(); ++y) {
                Float newValue = Float.valueOf(measurementsList.get(i).getValues().get(y).floatValue() - minValue);
                shiftedValues.add(newValue);
            }
            measurementsList.get(i).setValues(shiftedValues);
        }
        this.FindLowestValue(measurementsList);
    }

    public void ShiftValuesOfSingleSeries(float valueAboveZero, Measurement measurement) {
        Float minValue = Float.valueOf(this.FindLowestValueOfSingleSeries(measurement));
        ArrayList<Float> shiftedValues = new ArrayList<Float>();
        for (int i = 0; i < measurement.getValues().size(); ++i) {
            Float newValue = (double)measurement.getValues().get(i).floatValue() == 0.0 ? Float.valueOf(Float.parseFloat("0")) : Float.valueOf(BesanconReader.round2(measurement.getValues().get(i).floatValue() - (minValue.floatValue() - valueAboveZero), 2));
            shiftedValues.add(newValue);
        }
        measurement.setValues(shiftedValues);
        measurement.setMinimum(this.FindLowestValueOfSingleSeries(measurement));
        measurement.setMaximum(this.FindGreaterValueOfSingleSeries(measurement));
    }

    public void PrintSerie(Measurement measurement) {
        new Columns().addLine("Id of the curve: ", measurement.getId()).addLine("Lenght: ", Integer.toString(measurement.getLongueur())).addLine("Oldest ring: ", Integer.toString(measurement.getOrigine())).addLine("Younger ring: ", Integer.toString(measurement.getTerme())).addLine("Minimum: ", Float.toString(measurement.getMinimum())).addLine("Maximum: ", Float.toString(measurement.getMaximum())).print();
        System.out.println("Values:");
        for (int i = 0; i < measurement.getValues().size(); ++i) {
            System.out.print(measurement.getValues().get(i) + " ");
            if ((i + 1) % 10 != 0) continue;
            System.out.print("\n");
        }
    }

    public static float round2(float number, int scale) {
        int pow = 10;
        for (int i = 1; i < scale; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
    }

    public void SaveSeriesToFile(String file, Measurement measurement) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(file));
        pw.write("HEADER:");
        pw.write("KeyCode=" + measurement.getId());
        for (int i = 0; i < measurement.getValues().size(); ++i) {
        }
        pw.close();
    }
}

