/*
 * Decompiled with CFR 0.152.
 */
package dendro_command_line;

import dendro_command_line.Measurement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class BesanconValuesReader {
    List<Measurement> series = new ArrayList<Measurement>();
    int start;
    int lineNumber;
    File file;
    int lines = 0;
    int sets;
    Measurement measurement;

    public BesanconValuesReader(int start, File file, Measurement measurement) {
        this.start = start;
        this.file = file;
        this.measurement = measurement;
    }

    public ArrayList<Float> ReadSeries() {
        Object actualMeasurement = null;
        ArrayList<Float> values = new ArrayList<Float>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.file));
            LineNumberReader lnr = new LineNumberReader(br);
            String line = br.readLine();
            while (line != null) {
                ++this.lineNumber;
                if (this.lineNumber > this.start) {
                    String[] columns = line.trim().split("\\s+");
                    if (!line.endsWith(";")) {
                        for (int i = 0; i < columns.length; ++i) {
                            if (columns[i].equals(",")) {
                                values.add(Float.valueOf(Float.parseFloat("0")));
                                continue;
                            }
                            values.add(Float.valueOf(Float.parseFloat(columns[i])));
                        }
                    }
                    if (line.endsWith(";")) {
                        for (int y = 0; y < columns.length - 1; ++y) {
                            if (columns[y].equals(",")) {
                                values.add(Float.valueOf(Float.parseFloat("0")));
                                continue;
                            }
                            values.add(Float.valueOf(Float.parseFloat(columns[y])));
                        }
                        this.lineNumber = 0;
                        br.close();
                        return values;
                    }
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("file not found");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return values;
    }
}

