/*
 * Decompiled with CFR 0.152.
 */
package dendro_command_line;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Columns {
    List<List<String>> lines = new ArrayList<List<String>>();
    List<Integer> maxLengths = new ArrayList<Integer>();
    int numColumns = -1;

    public Columns addLine(String ... line) {
        int i;
        if (this.numColumns == -1) {
            this.numColumns = line.length;
            for (i = 0; i < this.numColumns; ++i) {
                this.maxLengths.add(0);
            }
        }
        if (this.numColumns != line.length) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < this.numColumns; ++i) {
            this.maxLengths.set(i, Math.max(this.maxLengths.get(i), line[i].length()));
        }
        this.lines.add(Arrays.asList(line));
        return this;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        String result = "";
        for (List<String> line : this.lines) {
            for (int i = 0; i < this.numColumns; ++i) {
                result = result + this.pad(line.get(i), this.maxLengths.get(i) + 1);
            }
            result = result + System.lineSeparator();
        }
        return result;
    }

    private String pad(String word, int newLength) {
        while (word.length() < newLength) {
            word = word + " ";
        }
        return word;
    }
}

