/*
 * Decompiled with CFR 0.152.
 */
package dendro_command_line;

import dendro_command_line.BesanconReader;
import dendro_command_line.Measurement;
import dendro_command_line.Sistema;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.Scanner;

public class Menu {
    private boolean ScreenHasToBeCleaned = true;
    Scanner in;
    BufferedReader br;
    int selectedOption;
    Sistema sistema = new Sistema();
    private Float minValue = Float.valueOf(Float.parseFloat("20"));
    ArrayList<Measurement> measurementsList = new ArrayList();

    public Menu() {
        this.in = new Scanner(System.in);
    }

    public static void clearScreen() {
        try {
            String os = System.getProperty("os.name");
            if (os.contains("Windows")) {
                System.out.println("");
                System.out.println("");
                System.out.println("");
            } else {
                System.out.print("\u001b[H\u001b[2J");
                System.out.flush();
            }
        }
        catch (Exception e) {
            System.out.println("Thare is a problem with the 'Clearig console' of the system. My fault. I apologize.");
        }
    }

    public void showMainMenu() {
        boolean invalidInput = false;
        block9: while (true) {
            if (this.ScreenHasToBeCleaned) {
                Menu.clearScreen();
            }
            if (invalidInput) {
                System.out.println("Invalid input, please try again");
                invalidInput = false;
            }
            System.out.println("");
            System.out.println(" ** Besan\u00e7on standardized tree-rings data converter ** ");
            System.out.println("");
            System.out.println("----------------------------");
            System.out.println("       Main menu      ");
            System.out.println("----------------------------");
            System.out.println("[1] Help");
            System.out.println("[2] Check User directory");
            System.out.println("[3] Read Besan\u00e7on file");
            System.out.println("[4] Exit program");
            System.out.println("----------------------------");
            System.out.println("");
            System.out.print("Select an option. Write the number and press 'Enter'");
            System.out.println("");
            System.out.println("");
            try {
                this.selectedOption = this.in.nextInt();
                switch (this.selectedOption) {
                    case 1: {
                        Menu.clearScreen();
                        this.setScreenHasToBeCleaned(false);
                        System.out.println("No help avaiable here. Please read the README.txt file for help.");
                        continue block9;
                    }
                    case 2: {
                        Menu.clearScreen();
                        this.setScreenHasToBeCleaned(false);
                        this.sistema.getPropriedadesSO();
                        this.sistema.getCarpetas();
                        continue block9;
                    }
                    case 3: {
                        Menu.clearScreen();
                        this.menuReader();
                        continue block9;
                    }
                    case 4: {
                        this.quitProgram();
                        continue block9;
                    }
                }
                invalidInput = true;
                continue;
            }
            catch (InputMismatchException ime) {
                invalidInput = true;
                this.in.next();
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException input, please try again");
                continue;
            }
            break;
        }
    }

    public void menuReader() {
        boolean invalidInput = false;
        block9: while (true) {
            if (this.ScreenHasToBeCleaned) {
                Menu.clearScreen();
            }
            if (invalidInput) {
                System.out.println("Invalid input, please try again");
                invalidInput = false;
            }
            System.out.println("");
            System.out.println("---------------------");
            System.out.println("  Step 1: Read file  ");
            System.out.println("---------------------");
            System.out.println("[1] Back to Main Menu");
            System.out.println("[2] Enter path of file to be read");
            if ("".equals(this.sistema.getNomDb())) {
                System.out.println("File currently selected: none");
            } else {
                System.out.println("File currently selected: " + this.sistema.getNomDb());
            }
            System.out.println("[3] Read file");
            System.out.println("----------------------------");
            System.out.println("");
            System.out.print("Select an option");
            System.out.println("");
            System.out.println("");
            try {
                this.selectedOption = this.in.nextInt();
                switch (this.selectedOption) {
                    case 1: {
                        Menu.clearScreen();
                        this.showMainMenu();
                        continue block9;
                    }
                    case 2: {
                        this.sistema.setNomDb();
                        continue block9;
                    }
                    case 3: {
                        try {
                            this.sistema.StartReading();
                        }
                        catch (Exception e) {
                            System.err.println(e.getClass().getName() + ": " + e.getMessage());
                            e.printStackTrace();
                            System.out.println("error while reading file");
                        }
                        continue block9;
                    }
                }
                invalidInput = true;
                continue;
            }
            catch (InputMismatchException ime) {
                invalidInput = true;
                this.in.next();
                continue;
            }
            break;
        }
    }

    public void setMinimumValue() {
        Scanner scanner = new Scanner(System.in);
        System.out.println("Enter the minimum value of rings");
        this.minValue = Float.valueOf(Float.parseFloat(scanner.nextLine()));
    }

    public void FocusOnMeasurement(ArrayList<Measurement> measurementsList) {
        for (int i = 0; i < measurementsList.size(); ++i) {
            System.out.println("[" + (i + 1) + "] " + measurementsList.get(i).getId());
        }
        Scanner scanner = new Scanner(System.in);
        System.out.println("Enter the number of the curve to be checked");
        BesanconReader br = new BesanconReader();
        br.PrintSerie(measurementsList.get(Integer.parseInt(scanner.nextLine()) - 1));
    }

    public void quitProgram() {
        System.out.println("Bye.");
        System.exit(1);
    }

    public void ShiftValues(ArrayList<Measurement> measurementsList) {
        boolean invalidInput = false;
        block8: while (true) {
            if (this.ScreenHasToBeCleaned) {
                Menu.clearScreen();
            }
            if (invalidInput) {
                System.out.println("Invalid input, please try again");
                invalidInput = false;
            }
            System.out.println("");
            System.out.println("---------------------------");
            System.out.println("   Step 2: Offset values   ");
            System.out.println("---------------------------");
            System.out.println("[1] Back to Main Menu");
            System.out.println("[2] Examine a single curve before transformation");
            System.out.println("[3] Enter the value above 0 to shift the curves");
            System.out.println("(Current value: " + this.minValue + ")");
            System.out.println("[4] Shift each curve to the minimum selected value");
            System.out.println("----------------------------");
            System.out.println("");
            System.out.print("Select an option");
            System.out.println("");
            System.out.println("");
            try {
                this.selectedOption = this.in.nextInt();
                switch (this.selectedOption) {
                    case 1: {
                        Menu.clearScreen();
                        Menu menu = new Menu();
                        menu.showMainMenu();
                        continue block8;
                    }
                    case 3: {
                        Menu.clearScreen();
                        this.setMinimumValue();
                        continue block8;
                    }
                    case 4: {
                        Menu.clearScreen();
                        BesanconReader breader = new BesanconReader();
                        for (int i = 0; i < measurementsList.size(); ++i) {
                            breader.ShiftValuesOfSingleSeries(this.minValue.floatValue(), measurementsList.get(i));
                        }
                        this.SaveFile(measurementsList);
                        continue block8;
                    }
                    case 2: {
                        Menu.clearScreen();
                        this.setScreenHasToBeCleaned(false);
                        this.FocusOnMeasurement(measurementsList);
                        continue block8;
                    }
                }
                invalidInput = true;
                continue;
            }
            catch (InputMismatchException ime) {
                invalidInput = true;
                this.in.next();
                continue;
            }
            break;
        }
    }

    public void SaveFile(ArrayList<Measurement> measurementsList) {
        String pathToFileToBeSaved = System.getProperty("user.home") + File.separator + "BesFileConverted.fh";
        boolean invalidInput = false;
        block10: while (true) {
            if (this.ScreenHasToBeCleaned) {
                Menu.clearScreen();
            }
            if (invalidInput) {
                System.out.println("Invalid input, please try again");
                invalidInput = false;
            }
            System.out.println("");
            System.out.println("-------------------------------------------");
            System.out.println("   Step 3: Save transformed data to file   ");
            System.out.println("-------------------------------------------");
            System.out.println("[1] Back to Main Menu");
            System.out.println("[2] Examine a single curve after transformation");
            System.out.println("[3] Type of file (Current type: '.fh'. By the moment, this is the only one avaiable)");
            System.out.println("[4] Path to file");
            if ("".equals(this.sistema.getNomDb())) {
                System.out.println("File currently selected: none");
            } else {
                System.out.println("File currently selected: " + pathToFileToBeSaved);
            }
            System.out.println("[5] Write file");
            System.out.println("----------------------------");
            System.out.println("");
            System.out.print("Select an option");
            System.out.println("");
            System.out.println("");
            try {
                this.selectedOption = this.in.nextInt();
                switch (this.selectedOption) {
                    case 1: {
                        Menu.clearScreen();
                        this.showMainMenu();
                        continue block10;
                    }
                    case 2: {
                        Menu.clearScreen();
                        this.FocusOnMeasurement(measurementsList);
                        System.out.println();
                        System.out.println("(Tree-rings values are presented here with two decimal place;");
                        System.out.println("when data will be written to file, they will be rounded.)");
                        continue block10;
                    }
                    case 3: {
                        Menu.clearScreen();
                        this.setScreenHasToBeCleaned(false);
                        System.out.println("Sorry, currently the only file format allowed is '.fh' (Heidelberg format)");
                        continue block10;
                    }
                    case 4: {
                        Menu.clearScreen();
                        this.setScreenHasToBeCleaned(false);
                        pathToFileToBeSaved = this.sistema.setPathToFileToBeSaved();
                        continue block10;
                    }
                    case 5: {
                        Menu.clearScreen();
                        this.SaveSeriesToFile(pathToFileToBeSaved, measurementsList);
                        continue block10;
                    }
                }
                invalidInput = true;
                continue;
            }
            catch (InputMismatchException ime) {
                invalidInput = true;
                this.in.next();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IO error trying to read your input." + ioe);
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public void SaveSeriesToFile(String file, ArrayList<Measurement> measurementsList) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(file));
        for (int i = 0; i < measurementsList.size(); ++i) {
            pw.println("HEADER:");
            pw.println("KeyCode=" + measurementsList.get(i).getId());
            pw.println("Length=" + measurementsList.get(i).getLongueur());
            pw.println("DateEnd=" + measurementsList.get(i).getTerme());
            pw.println("Unit=1/100");
            pw.println("DATA:Tree");
            for (int y = 0; y < measurementsList.get(i).getValues().size(); ++y) {
                int newValue = Math.round(measurementsList.get(i).getValues().get(y).floatValue());
                pw.write(" " + newValue);
                if ((y + 1) % 10 != 0) continue;
                pw.println();
            }
            pw.println();
            pw.println();
        }
        pw.close();
        System.out.println("File saved");
    }

    public static float round2(float number, int scale) {
        int pow = 10;
        for (int i = 1; i < scale; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
    }

    public void setScreenHasToBeCleaned(boolean ClearScreen) {
        this.ScreenHasToBeCleaned = ClearScreen;
    }
}

